package org.jcon.ba.system;

import org.jcon.util.GenLib;
import java.util.Vector;

/**
 * Defines the initial state of an Item. Designed to be
 * the bridge mechanism between an Item and text
 * persistence. Hence the contents are reducible to text.
 *
 * @author Jack Harich
 */
public class ItemDef {

//---------- Private Fields ------------------------------
//----- Properties
private String  itemName;
private String  beanClassName;
private boolean isContainer;
private Vector  configLines; // Each is a String
private boolean isInvocated;

// The following are null if none:
private String markerClassName; // To reuse a tree
private String paramMarkerClassName;
private String paramMarkerItemName;
private String paramFileName;

//---------- Properties ----------------------------------
//----- itemName
public void setItemName(String itemName) {
    this.itemName = itemName.trim();
}
public String getItemName() {
    return itemName;
}
//----- beanClassName
public void setBeanClassName(String beanClassName) {
    this.beanClassName = beanClassName;
}
public String getBeanClassName() {
    return beanClassName;
}
//----- isContainer
public void setContainer(boolean isContainer) {
    this.isContainer = isContainer;
}
public boolean isContainer() {
    return isContainer;
}
//----- markerClassName
public void setMarkerClassName(String markerClassName) {
    this.markerClassName = markerClassName;
}
public String getMarkerClassName() {
    return markerClassName;
}
//----- configLines
public void setConfigLines(Vector configLines) {
    this.configLines = configLines;
}
public Vector getConfigLines() {
    if (configLines == null) configLines = new Vector();
    return configLines;
}
//----- isInvocated
/**
* Sets the Invocated property, which if true means that
* invocations have already been called for this Item. This
* allows us to avoid invocating an Item twice.
*/
public void setInvocated(boolean isInvocated) {
    this.isInvocated = isInvocated;
}
public boolean isInvocated() {
    return isInvocated;
}
//----- paramMarkerClassName
public void setParamMarkerClassName(String name) {
    paramMarkerClassName = name;
}
public String getParamMarkerClassName() {
    return paramMarkerClassName;
}
//----- paramMarkerItemName
public void setParamMarkerItemName(String paramMarkerItemName) {
    this.paramMarkerItemName = GenLib.trim(paramMarkerItemName);
}
public String getParamMarkerItemName() {
    return paramMarkerItemName;
}
//----- paramFileName
public void setParamFileName(String paramFileName) {
    this.paramFileName = GenLib.trim(paramFileName);
}
public String getParamFileName() {
    return paramFileName;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
