package org.jcon.ba.system;

/**
 * A privileged bean instance is allowed to access its
 * containing Basket. This is done by calling setBasketServices()
 * on the instance during initialization. Thereafter the
 * instance can use ModuleServices for rather important
 * behavior such as event propogation, item sharing and
 * mediator.
 *
 * For a more understandable and simple system, only a few
 * items in a module should be priviledged. Otherwise the
 * module has the equivalent of "too many cooks."
 *
 * @author Jack Harich
 */
public interface BeanPriv {

/**
 * This provides the item with the same ModuleServices
 * instance that other items in the same module have.
 * See ModuleServices for documentation.
 */
public void setBasketServices(BasketServices services);

} // End class


/**

import org.jcon.ba.system.BasketServices;
import org.jcon.ba.system.BeanPriv;

//---------- BeanPriv Implementation ---------------------
public void setBasketServices(BasketServices services) {
    basketServices = services;
}


*/
