package org.jcon.ba.system;

/**
 * A bean may optionally implement this interface to
 * receive notification that it should start.
 *
 * @author Jack Harich
 */
public interface BeanActionStart {

/**
 * This is never called unless deliberately placed in a
 * container's primordial invocations. Use of this method
 * is preferred to other primordial methods, since they
 * will be called via reflection, and are thus harder to
 * debug when exceptions occur.
 * <p>
 * Good news. Java 1.1.7 or so fixed the bug that caused
 * methods called with reflection to not have the full
 * stack trace available.
 */
public void start();


} // End interface


/**

import org.jcon.ba.system.BeanActionStart;

//----------- BeanActionStart Implementation --------------
public void start() {

}

*/
