package org.jcon.ba.system;

/**
 * A bean may optionally implement this interface to
 * receive notification that it should pause or resume.
 *
 * @author Jack Harich
 */
public interface BeanActionPause {

/**
 * The bean should stop doing something.
 * For example it might stop accepting input or firing events.
 */
public void pause();

/**
 * The bean should resume doing something.
 * For example it might start accepting connections.
 */
public void resume();


} // End interface

/*

import org.jcon.ba.system.BeanActionPause;

//----------- BeanActionPause Implementation --------------
public void pause() {

}
public void resume() {

}

*/
