package org.jcon.ba.system;

/**
 * A bean may optionally implement this interface to
 * receive notification that it may perform appropriate
 * initialization.
 *
 * @author Jack Harich
 */
public interface BeanActionInit {

/**
 * Called during a container start, after all items in the
 * container have been created, provided with Param and
 * BasketServices, and configured.
 * <p>
 * If a bean implements both BeanActionInit and
 * BeanActionStart init() is always called first.
 * <p>
 * Do not fire Messages in this method, since other beans
 * might not have completed their init() and to avoid an
 * infinite loop due to container design.
 */
public void init();


} // End interface

/*
import org.jcon.ba.system.BeanActionInit;

//---------- BeanActionInit Implementation ---------------
public void init() {
    //*** do
}

*/
