package org.jcon.ba.system;

/**
 * A bean may optionally implement this interface to
 * imply it needs closing when its container is closed.
 * This is necessary when a bean may have a system resource
 * such as a file, connection or window open, or if
 * performing a process.
 *
 * @author Jack Harich
 */
public interface BeanActionClose {

/**
 * The bean should return null if it can close now or a
 * String explaining why not.
 * For example if dirty it could return "Document Test.txt
 * is open and needs saving."
 */
public String canClose();

/**
 * The bean should release all resources and end all
 * processes immediately, in as smooth a manner as possible.
 */
public void close();


} // End interface


/*

import org.jcon.ba.system.BeanActionClose;

//---------- BeanActionClose Implementation --------------
public String canClose() {
    return null; // Yes
}
public void close() {

}

*/
