package org.jcon.ba.lib;

import java.util.Locale;

/**
* The unit test for LocaleMgr. Directory structure is: <p> <pre>
*   locale
*      LocaleMarker.class
*	   en_US
*		  LogonWindow.locale
* </pre>
*
* @author Jack Harich
*/  // java org.jcon.ba.lib.LocaleMgrTest
public class LocaleMgrTest {

//---------- Private Fields ------------------------------
private LocaleMgr localeMgr = new LocaleMgr();

//---------- Initialization ------------------------------
public static void main(String args[]) {
	new LocaleMgrTest().runUnitTest();
}
//---------- Public Methods ------------------------------
public void runUnitTest() {
    localeMgr.setMarkerClassName("com.realm.client.locale.LocaleMarker");
    localeMgr.setLocale("en", "US", null);
    
    test("LogonWindow", "UserID");
    test("LogonWindow", "Password");
    test("LogonWindow", "OkayBtn");
    test("LogonWindow", "CancelBtn");
    

    // Note Java bug - Locale.US is a country, but the
    // output is "en_US".
    //print(" - " + Locale.ENGLISH + " " + Locale.US);
    
}
//---------- Private Methods -----------------------------
private void test(String area, String key) {
    print(" - " + key + " = '" + localeMgr.getString(area, key) + "'");
}
//--- Std
private static void print(String text) {
    System.out.println("LocaleMgrTest" + text);
}


} // End class
