package org.jcon.ba.edit;

import org.jcon.ui.WindowLib;
import org.jcon.ui.WindowMgr;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

import javax.swing.JToggleButton;
import javax.swing.JFrame;

/**
 * The VIEW for a configurator presents an item's
 * configurable state and allows configuration.
 *
 * @author Jack Harich
 */
public class ConfigView implements
    ActionListener, WindowListener {

//---------- Private Fields ------------------------------
private ConfigMgr configMgr;
private Frame     frame = WindowMgr.createRegisteredFrame();

private List       configLinesList = new List();
private TextField  paramMarkerItemTf = new TextField(20);
private TextField  paramFileTf = new TextField(30);
private List       primordialConfigLinesList = new List(3);

private JToggleButton parentViewToggleBtn = new JToggleButton("ParentView");
private JToggleButton recordToggleBtn = new JToggleButton("Record");
private Button    saveBtn = new Button("Save");
private Button    revertBtn = new Button("Revert");
private Button    deleteBtn = new Button("Delete");
private Button    moveUpBtn = new Button("Move Up");
private Button    moveDownBtn = new Button("Move Down");

//---------- Initialization ------------------------------
public ConfigView(ConfigMgr configMgr) {
    this.configMgr = configMgr;

    //----- Frame
    frame.setTitle("Configurator");
    frame.setBackground(Color.lightGray);
    frame.addWindowListener(this);
    frame.setSize(650, 300);
    WindowLib.position(frame, WindowLib.LOWER_RIGHT);

    //----- Center - Item configuration lines
    Panel configPanel = new Panel();
	if (frame instanceof JFrame) {
    	((JFrame)frame).getContentPane().add("Center", configPanel);
	} else {
    	frame.add("Center", configPanel);
	}
    configPanel.setLayout(new BorderLayout());

    // Button bar - bold label LEFT and buttonRow RIGHT
    Panel buttonBar = new Panel();
    buttonBar.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 2));
    configPanel.add("North", buttonBar);
    configPanel.add("Center", configLinesList);

    buttonBar.add(createBoldLabel(" Item Invocations"));

    Panel buttonRow = new Panel();
    buttonRow.setLayout(new FlowLayout(FlowLayout.RIGHT, 5, 2));
    buttonBar.add(buttonRow);

    buttonRow.add(parentViewToggleBtn);
    parentViewToggleBtn.setActionCommand("ToggleParentView");
    parentViewToggleBtn.addActionListener(this);
    buttonRow.add(recordToggleBtn);

    buttonRow.add(initButton(saveBtn, "Save"));
    buttonRow.add(initButton(revertBtn, "Revert"));
    buttonRow.add(initButton(deleteBtn, "Delete"));
    //buttonRow.add(initButton(moveUpBtn, "MoveUp"));
    //buttonRow.add(initButton(moveDownBtn, "MoveDown"));

    //----- South - Various
    Panel southPanel = new Panel();
	if (frame instanceof JFrame) {
		((JFrame)frame).getContentPane().add("South", southPanel);
	} else {
    	frame.add("South", southPanel);
	}
    southPanel.setLayout(new BorderLayout());

    // ParamDriven data
    Panel paramPanel = new Panel();
    southPanel.add("North", paramPanel);
    paramPanel.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));

    paramPanel.add(new Label("Param Marker Item"));
    paramPanel.add(paramMarkerItemTf);
    paramPanel.add(new Label("File Name"));
    paramPanel.add(paramFileTf);

    // Primordial Invocations
    Panel primordialPanel = new Panel();
    southPanel.add("Center", primordialPanel);
    primordialPanel.setLayout(new BorderLayout());

    primordialPanel.add("North", createBoldLabel(" Primordial Invocations"));
    primordialPanel.add("Center", primordialConfigLinesList);

    //----- Misc
    refreshState();
}
private Button initButton(Button button, String command) {
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
public static void main(String args[]) { // Unit test
    ConfigView view = new ConfigView(null);
    view.setParamDriven(false);
    view.setContainer(false);
    view.setVisible(true);
//view.paramFileTf.setBackground(Color.gray);
}
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();

    if (command == "ToggleParentView") {
        if (configMgr != null) configMgr.toggleParentView();
    }
}
//---------- WindowListener Implementatons ---------------
public void windowClosing(WindowEvent evt) {
    // User clicked on X or chose window Close
    configMgr.windowClosingRequested();
}
public void windowClosed(WindowEvent evt) { }
public void windowDeiconified(WindowEvent evt) { }
public void windowIconified(WindowEvent evt) { }
public void windowOpened(WindowEvent evt) { }
public void windowActivated(WindowEvent evt) {  }
public void windowDeactivated(WindowEvent evt) { }

//---------- Properties ----------------------------------
//----- Visible
public void setVisible(boolean visible) {
    frame.setVisible(visible);
}
public boolean isVisible() {
    return frame.isVisible();
}
//----- ParentView - true if toggle button depressed
public boolean isParentView() {
    return parentViewToggleBtn.isSelected();
}
public void setParentViewEnabled(boolean enabled) {
    parentViewToggleBtn.setEnabled(enabled);
}
//----- Other
public void setTitle(String title) {
    frame.setTitle(title);
}
public void setParamMarkerItem(String name) {
    paramMarkerItemTf.setText(name);
}
public void setParamFile(String name) {
    paramFileTf.setText(name);
}
public void setParamDriven(boolean isParamDriven) {
    // For some bizarre reason lightGray fails to work
    // and gray shows as lightGray *** awt bug
    Color color = (isParamDriven ? Color.white : Color.gray);
    paramMarkerItemTf.setBackground(color);
    paramFileTf.setBackground(color);
    if (! isParamDriven) {
        setParamMarkerItem(null);
        setParamFile(null);
    }
}
public void setContainer(boolean isContainer) {
    if (isContainer) {
        primordialConfigLinesList.setBackground(Color.white);
        parentViewToggleBtn.setEnabled(true);
    } else {
        primordialConfigLinesList.setBackground(Color.lightGray);
        parentViewToggleBtn.setEnabled(false);
    }
}
//---------- Public Methods ------------------------------
public void clearItemConfigLines() {
    configLinesList.removeAll();
}
public void clearPrimordialConfigLines() {
    primordialConfigLinesList.removeAll();
}
public void loadItemConfigLines(Vector lines) {
        configLinesList.removeAll();
        if (lines.size() == 0) {
            configLinesList.addItem("(none)");
        } else {
            for (int i = 0; i < lines.size(); i++) {
                configLinesList.addItem((String)lines.elementAt(i));
            }
        }
}
public void loadPrimordialConfigLines(Vector lines) {
    primordialConfigLinesList.removeAll();
    if (lines.size() == 0) {
        primordialConfigLinesList.addItem("(none)");
    } else {
        for (int i = 0; i < lines.size(); i++) {
            primordialConfigLinesList.addItem((String)lines.elementAt(i));
        }
    }
}
public void refreshState() {
    // *** do button state
}
//---------- Private Methods -----------------------------
private Label createBoldLabel(String text) {
    Label label = new Label(text);
    label.setFont(new Font("Dialog", Font.BOLD, 14));
    return label;
}
//--- Std
private static void print(String text) {
    System.out.println("ConfigView" + text);
}

} // End class
