package org.jcon.ba.edit;

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.msg.MessageSourceStd;
import org.jcon.ba.system.*;
import java.util.Vector;

/**
 * The controller for the configurator.
 *
 * @author Jack Harich
 */
public class ConfigMgr extends MessageSourceStd
    implements MessageListener {

//---------- Private Fields ------------------------------
private ConfigView view = new ConfigView(this);
private Object     currentGroupID;
private Item       currentItem;
private boolean    autoToggleOn = false; // Agrees with main menu

//---------- MessageSourceStd Abstractions ---------------
public Vector getMessageDefs() {
    Vector defs = new Vector();
    MessageDef def;

    def = new MessageDef("AutoConfiguratorClosed", this);
    defs.addElement(def);

    return defs;
}
//---------- MessageListener Implementation --------------
public void processMessage(Message message) {
    String name = message.getName();
    //print(".processMessage() - name " + name);

    if (name == "ItemSelected") {
        itemSelected((Item)message.get("Item"),
            message.get("GroupID"));

    } else if (name == "ToggleAutoConfigurator") {
        toggleView(message.isTrue("ToggleOn"));

    } else if (name == "GroupClosed") {
        groupClosed(message.get("GroupID") );
    }
}
public String[] loadMessageInterests() {
    return new String[] {"ItemSelected",
        "ToggleAutoConfigurator", "GroupClosed"};
}
//---------- Package Methods ------------------------------
void toggleParentView() {
    refreshView();
}
void windowClosingRequested() {
    view.setVisible(false);
    autoToggleOn = false;
    messageRouter.fire("AutoConfiguratorClosed", this);
}
//---------- Private Methods -----------------------------
private void refreshView() {
    if (currentItem == null) {
        clearView();
    } else {
        // Duplicate event
        itemSelected(currentItem, currentGroupID);
    }
}
private void itemSelected(Item item, Object groupID) {
    if (! item.isContainer() && ! item.isBeanWrapper()) return; // This may change later

    // Save selected item state
    currentItem = item;
    currentGroupID = groupID;

    if ( ! autoToggleOn || ! view.isVisible()) return;

    // Set 3 variables
    BasketDef basketDef = null;
    String itemName = item.getItemName();
    String itemDefName = itemName;

    if (item.getParentItem() == null) {
        // Root
        basketDef = item.getBasket().getBasketDef();
        itemDefName = "this";

    // Note we do not handle the "both" case well ***
    } else if(item.isContainer()) {
        // Basket that is not the root
        if (view.isParentView()) {
            Item parentItem = item.getParentItem();
            basketDef = parentItem.getBasket().getBasketDef();
        } else {
            basketDef = item.getBasket().getBasketDef();
            itemDefName = "this";
        }
    } else if (item.isBeanWrapper()){
        // Bean
        Item parentItem = item.getParentItem();
        basketDef = parentItem.getBasket().getBasketDef();
    }
    // Title
    String className = "(no bean)";
    if (item.isBeanWrapper()) className = item.getBeanInstance().getClass().getName();
    view.setTitle("Configurator - " + item.getPath(false) + " - " + className);

    // Item invocations
    ItemDef itemDef = basketDef.getItemDef(itemDefName);
    view.loadItemConfigLines(itemDef.getConfigLines());

    // ParamDriven
    if (item.isParamDrivenBean()) {
        view.setParamDriven(true);
        view.setParamMarkerItem(itemDef.getParamMarkerItemName());
        view.setParamFile(itemDef.getParamFileName());
    } else {
        view.setParamDriven(false);
    }
    // Primordial invocations
    view.setContainer(item.isContainer());
    if (item.isContainer()) {
        view.loadPrimordialConfigLines(basketDef.getPrimordialInvocations());
    } else {
        view.clearPrimordialConfigLines();
    }
    // Misc, Done
    if (item.getParentItem() == null) view.setParentViewEnabled(false);
    if (! view.isVisible()) view.setVisible(true);
}
private void toggleView(boolean autoToggleOn) {
    this.autoToggleOn = autoToggleOn;
    refreshView();
    view.setVisible(autoToggleOn);
}
private void groupClosed(Object groupID) {
    // Replace autoInspector with new empty one
    if (currentGroupID == groupID) {
        clearView();
        currentItem = null;
        currentGroupID = null;
    }
}
private void clearView() {
    view.setTitle("Configurator");
    view.setParamDriven(false);

    view.clearItemConfigLines();
    view.clearPrimordialConfigLines();

    view.refreshState();
}
//--- Std
private static void print(String text) {
    System.out.println("ConfigMgr" + text);
}

} // End class
