package org.jcon.ba;

import org.jcon.ui.OutputConsole;
import org.jcon.ba.system.ItemSystemMgr;

/**
 * The Bean Assembler entry point and marker class.
 * This marker class and parex file
 * form the root of an item system.
 *
 * Note the companion _Container.parex file, which must be in
 * the same directory unless a custom ParamStore is set.
 *
 * The main() method illustrates the correct way to start
 * a system directly with the System Engine. The use of the
 * OutputConsole is optional.
 *
 * @author Jack Harich
 */
public class Assembler {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    if (args.length > 0) {
        new OutputConsole().setVisible(true);
    }
    // Note - We could call
    //    ItemSystemMgr.setParamStoreDefault(...)
    // before calling startSystem()
    new ItemSystemMgr().startSystem(new Assembler(), args);
}


} // End class
