package uhr.core.msg;

/**
* This interface allows monitoring the message stream of a
* MessageRouter. Notification is sent before and after the
* router sends a message to a receiver.
* <p>
* Note that the MessageSenders will not always be the original 
* sender, but the one that sent the message to the router.
*
* @author Jack Harich
*/
public interface MessageMonitor {

//---------- Public Methods --------------------------------------

/**
* Signifies that a message is about to be sent to the receiver.
*
* @param message  the message about to be sent.
* @param sender   the sender of the message.
* @param receiver the receiver about to receive the message.
* @param connectionType  the connection type involved.
*/
public void monitorBefore(Message message, 
                          MessageSender sender,
                          MessageReceiver receiver,
                          int connectionType);

/**
* Signifies that a message has just been sent to the receiver.
*
* @param message  the message just sent.
* @param sender   the sender of the message.
* @param receiver the receiver who received the message.
* @param connectionType  the connection type involved.
*/
public void monitorAfter (Message message, 
                          MessageSender sender,
                          MessageReceiver receiver,
                          int connectionType);


} // End interface