package uhr.core.tron;

/**
* This class is a lightweight tree datatron with null values allowed
* and ordered keys, since their order may be information itself.
* <p>
* The key separator is "/", so don't use that in any keys. "/" is
* only for nested key separation.
* <p>
* This class is for general purpose use, such as in passing
* structured data around.
*
* @author Jack Harich
*/ 
public class InfotronStd extends FlexitronStd implements Infotron {

//---------- Initialization --------------------------------------
/**
* Constructor that configures the Flexitron to not isElementalOnly,
* isAutoDetectDuplicateKeys, null values allowed, and key separator = "/".
*/
public InfotronStd() {
    // Configure
    // (isElementalOnly, isAutoDetectDuplicateKeys, isNullValueAllowed, keySeparator)
    super(false, true, true, "/");
}


} // End class