package uhr.core.tron;

/**
* This class is a single element of data in a collection. 
* An Element is immutable.
*
* @author Jack Harich
*/
public class Element {

//---------- Internal Fields -------------------------------------
protected String key;
protected Object value;

//---------- Initialization --------------------------------------
/**
* Creates a new Element with the key and value.
* @param key  the key, which should not be null.
* @param value  the value, which may be null.
* @exception IllegalArgumentException if the key is null.
*/
public Element(String key, Object value) {
    if (key == null) throw new IllegalArgumentException(
        "The key cannot be null.");
    
    this.key   = key;
    this.value = value;
}
//---------- Properties ------------------------------------------
/**
* Returns the key.
* @return the key.
*/
public String getKey() {
    return key;
}
/**
* Returns the value, which may be null.
* @return  the value.
*/
public Object getValue() {
    return value;
}
//---------- Superclass Overrides --------------------------------
/**
* Compares two elements.
* The result is <code>true</code> if and only if the argument is 
* not <code>null</code> and is an <code>Element</code> object that 
* represents the same key and value as this object.
*
* @param   object   the object to compare with.
* @return  <code>true</code> if the objects are the same;
*          <code>false</code> otherwise.
*/
public boolean equals(Object object) {
    return object != null && 
           object instanceof Element && 
           key == ((Element) object).getKey() &&
           (value == null || value == ((Element) object).getValue() );
}

} // End class