package uhr.core.test;

import uhr.core.tron.SimpleParserXML;
import uhr.core.tron.Infotron;
import uhr.core.tron.InfotronStd;

/**
* This class is the unit test for PropMap. 
* <p>
* The test is: java -nojit uhr.core.test.SimpleParserXML_Test1
*
* @author Jack Harich
*/
public class SimpleParserXML_Test1 {

//---------- Initialization --------------------------------------
/**
* Runs the unit test.
*/
public static void main(String[] args) {
    new SimpleParserXML_Test1().runUnitTest();
}
//---------- Public Methods --------------------------------------
/**
* Returns null if test okay or a String describing failure.
* (Can become UnitTest interface method)
*/
public String runUnitTest() {
    // Shared variables
    String text = "";
    Infotron tron = null;
    
    // Understand Infotron put() and toString()
    tron = new InfotronStd();
    tron.add("A/B", "data B");
    tron.add("A/C", "data C");
    //printTron(tron);
    
    // Test
    // Create text
    text = "" +
    "<?xml version='1.0' standalone='yes'?>\n" +
    "<!--This is a comment-->\n" +
    "<parts>\n" +
    "    <part>\n" +
    "        <name>LogonWindow</name>\n" +
    "        <type>uhr.parts.ui.Window</type>\n" +
    "        </part>\n" +
    "    <part>\n" +
    "        <name>SecurityDataReader</name>\n" +
    "        <type>uhr.parts.io.FileReader</type>\n" +
    "        <dk>url for dk here</dk>\n" +
    "        <abilities>service, core</abilities>\n" +
    "        </part>\n" +
    "    <MsgName>\n" +
    "        A, B, C;\n" +
    "        X, Y, Z;\n" +
    "        </MsgName>\n" +
    "    <MsgName2>\n" +
    "        </MsgName2>\n" +
    "    <A><B>dataB</B><C><D>dataD</D></C></A>\n" +
    "    </parts>\n";

    //ok text = "<A>data</A>";
    //ok text = "<A><B></B></A>";
    //ok text = "<A><B>data</B><C><D>data2</D></C></A>";
    
    // Convert to Infotron and printout results
    testPrint("- Text = \n" + text);
    tron = new SimpleParserXML().parse(text);
    printTron(tron);
    return null;
}
//---------- Protected Methods -----------------------------------
protected void printTron(Infotron tron) {
    testPrint("- The Infotron contains:\n'" + tron + "'");
}    
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("SimpleParserXML_Test1" + text);
}
private static void testPrint(String text) {
    System.out.println(text);
}

} // End class