package uhr.core.test;

import uhr.core.tron.PropMap;
import uhr.core.tron.PropMapStd;

/**
* This class is the unit test for PropMap. 
* <p>
* The test is: java -nojit uhr.core.test.PropMapStd_Test1
* <p>
* BUG - isOrderedKeys = false fails to show B and C properly.
*
* @author Jack Harich
*/ 
public class PropMapStd_Test1 {

//---------- Internal Fields -------------------------------------

//---------- Initialization --------------------------------------
public static void main(String args[]) {
    new PropMapStd_Test1().runUnitTest();
}
//---------- Public Methods --------------------------------------
/**
* Returns null if test okay or a String describing failure.
* (Can become UnitTest interface method)
*/
public String runUnitTest() {
    PropMap map = new PropMapStd();
    
    // Unconfigured test
    map.put("Key1", "Martha");
    //map.put("Key2", null); // Provoked exception
    map.put("Key3", "Helen");
    print(" - Unconfigured map is: " + map);
    
    // Configured test
    // (isNullValueAllowed, isOrderedKeys, keySeparator)
    map = new PropMapStd(true, true, "/");
    
    map.put("A/B", "data B");
    map.put("A/C", "data C");
        
    map.put("Key1", "Martha");
    map.put("Key2",  null);
    map.put("Key3Container/Georgia/Dekalb", "Clarkston");
    map.put("Key3Container/Georgia/Fulton", "Atlanta");
    map.put("Key4", "Helen");
    map.insertBefore("Key1.5", "Betsy", "Key2");
    
    print(" - Configured map is: \n\n" + map + "\n");
    print(" - Size = " + map.getSize());
    print(" - Deep key Atlanta = " + map.get("Key3Container/Georgia/Fulton"));
    
    // Done
    return null;
}
//---------- Protected Methods -----------------------------------

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("PropMapStd_Test1" + text);
}

} // End class