package uhr.core.test;

import uhr.core.tron.Flexitron;
import uhr.core.tron.FlexitronStd;

/**
* This class is the unit test for Flexitron. 
* <p>
* The test is: java -nojit uhr.core.test.FlexitronStd_Test1
* <p>
*
* @author Jack Harich
*/ 
public class FlexitronStd_Test1 {

//---------- Initialization --------------------------------------
public static void main(String args[]) {
    new FlexitronStd_Test1().runUnitTest();
}
//---------- Public Methods --------------------------------------
/**
* Returns null if test okay or a String describing failure.
* (Can become UnitTest interface method)
*/
public String runUnitTest() {
    Flexitron tron = createTron();
    
    tron.add("Key1", "Value1");
    tron.add("Key2", null);
    tron.add("Key3", "Value3");
    tron.add("Key4", new FlexitronStd()); 
    tron.add("Key5", "Value5");
    tron.add("Key6", createSubTron1());
    tron.add("Key7", "Value7");
    tron.add("Key8", createSubTron2());
    tron.add("Key9", "Value9");    
    
    print(" - The Flexitron contains:\n" + tron + "\n");    
    String value = (String)tron.get("Key8/Key3");
    print(" - The value for 'Key8/Key3' is '" + value + "'");
        
    print(" - The value for 'Key8/Key4' is '" + 
        tron.isTrue("Key8/Key4") + "'");

    // Done
    return null;
}
//---------- Protected Methods -----------------------------------
protected Flexitron createTron() {
    return new FlexitronStd(false, true, true, "/");
}
protected Flexitron createSubTron1() { // Elemental
    Flexitron tron = createTron();
    tron.add("Key1", "Value1");
    tron.add("Key2", null);
    tron.add("Key2", "not null");
    tron.add("Key3", "Value3");
    return tron;
}
protected Flexitron createSubTron2() {
    Flexitron tron = createTron() ;
    tron.add("Key1", "Value1");
    tron.add("Key2", "not null");
    tron.add("Key3", "Value3");
    tron.setBoolean("Key4", false);
    return tron;
}

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("FlexitronStd_Test1" + text);
}

} // End class