package uhr.core.role;

/**
* A class may optionally implement this interface to 
* indicate it can replicate itself.
*
* @author Jack Harich
*/
public interface Replicatable {

/**
* The instance should replicate itself. This is about half
* way between Java's "new" and "clone". The replication
* should include initialization state such as DK,
* but it should exclude current mission state, such as
* data read from a socket. This allows the replication to
* be used without the bother of initialization.
* <p>
* This is similar to life form reproduction. For example
* when a kitten is born, it has basic behavior and so is
* well initialized. But it lacks adult size and skills,
* and so lacks mission state.
*/
public Object replicate();


} // End interface


/**

import uhr.core.role.Replicable;

//----------- Replicable Implementation ------------------
*
* Returns a copy of itself without mission state.
* @return  the replication.
*
public Object replicate() {

}

*/