package uhr.core.role;

/**
* A class may optionally implement this interface to indicate it
* wants to use other parts. This is an example of the Object User
* Pattern.
* <p>
* Here "part name" represents a "slot" in a System Tree design.
* The slot name is the part name. A slot is a plugpoint that has
* specific published aspects. Currently we define a slot by the
* part or stub part that's in it. Slots are a concept Steve
* Alexander has been working on. In the future we expect to have
* a more true slot oriented design, at which point this interface
* could properly be named "SlotUser". :-)
*
* @author Jack Harich
*/
public interface PartUser {

/**
* Returns an array of the part names this part needs to
* do its work.
* @return  the names of the parts needed.
*/
public String[] getPartNamesNeeded();

/**
* Sets a named part, in response to part needs.
* <p>
* The part implementing this interface should continue working
* normally even if this method is called anytime, which can occur
* if the provided part is being replaced. This means it should
* keep only a simple reference to the part. If it collaborates
* only with messages, it need not synchronize anything, since
* messages will be paused during replacement.
*
* @param name  the name of the needed part.
* @param part  the needed part.
*/
public void setPart(String name, Object part);


} // End interface


/**

import uhr.core.role.PartUser;

//----------- PartUser Implementation ----------------------------
*
* Returns an array of the part names this part needs to
* do its work.
* @return  the names of the parts needed.
*
public String[] getPartNeeds() {
    return new String[] {"PartName1", "PartName2"};
}
*
* Sets a named part, in response to part needs. This implementation
* supports needed part replacement anytime. See the PartUser 
* interface for further documentation.
*
* @param name  the name of the needed part.
* @param part  the needed part.
*
public void setPart(String name, Object part) {
    
}

*/