package uhr.core.msg;

/**
* This widely used interface allows sending messages out of 
* something. We envision that this always means sending out of a 
* part. The part has no idea where the message goes, a powerful 
* loose coupling mechanism that is at the heart of UHR.
* <p>
* A MessageSender starts a "message chain" by calling the single
* method in MessageReceiver, <code>receive(Message)</code>. 
* Ultimately the message arrives at zero
* or more destinations, traveling through various infrastructure.
* At each step in the chain, MessageReceiver is used to transfer
* the message from one thing to another. Thus MessageSender and
* MessageReceiver form the datatron transport mechanism of UHR.
* <p>
* For speed the class should reuse Messages rather than creating 
* a new one for each send.
*
* @author Jack Harich
*/
public interface MessageSender {

//---------- Public Methods --------------------------------------

/**
* Sets the receiver to use when sending messages. Each class can 
* have only one receiver unless it's doing special work, such as a 
* message router.
* 
* @param receiver  the MessageReceiver to use when sending Messages.
*/
public void setMessageReceiver(MessageReceiver receiver);

} // End interface