package uhr.core.msg;

/**
* This widely used interface allows message transport from one thimg
* to another. This is a powerful loose coupling mechanism that is at
* the heart of UHR. There are several uses for MessageReceiver. 
* Together  they allow "message chains" to provide a system of parts
* with the equivalent of a central nervous system.
* <BLOCKQUOTE>
* 1. Message input to a part. The part never knows where the message
* comes from, or whether it's a normal or service Message. Generally
* the part will check the message name and use one public or 
* protected method per message property supported, unless trivial.
* The use of those public methods allows the flexibility of direct
* links (with interfaces) or use of messages. We may need a design
* standard here.
* <p>
* 2. Sending a message out of a part. This always happens when a 
* message is first sent from a MessageSender. It also occurs behind
* the scenes when a message is forwarded from one MessageRouter to 
* another MessageRouter.
* <p>
* 3. Monitoring messages in a MessageRouter. This is handy for tools
* and advanced domain parts. For example is allows system animation 
* by visually showing the flow of messages.
* </BLOCKQUOTE>
* If the message is not expected the class should not throw an
* exception, but it may complain such as by printing that it's
* ignoring the message name.
* <p>
* <b>The receiver should NOT keep a reference to the message</b>, 
* to allow the sender to reuse message objects. If a reference is 
* needed, do a clone or such.
*
* @author Jack Harich
*/
public interface MessageReceiver {

//---------- Public Fields ---------------------------------------
/**
* Indicates that the receiver has handled the message in a normal
* manner. This is the usual returned value.
*/
//public int NORMAL = 0;

/**
* Indicates the receiver was not interested in the message and
* has ignored it. This may indicate a system configuration error.
*/
//public int IGNORED = 1;

//---------- Public Methods --------------------------------------

/**
* The class should receieve the message and react intelligently. :-)
* <p>
* The class should check the message name and then do
* something per name, much like a method. Remember, the message
* name is interned, so <code>==</code> comparison may be used since
* it's faster and more concise.
* <p>
* @param message  the incoming message.
*/
public void receive(Message message);

} // End interface