package uhr.core.msg;

/**
* This class allows a part to dispatch (send) Messages without
* knowing where they are going. It's designed to be the receiver
* provided in 
* <code>MessageSender.setMessageReceiver (MessageReceiver receiver)</code>.
*
* @author Jack Harich
*/
public class MessageDispatcher implements MessageReceiver {

//---------- Internal Fields -------------------------------------
protected MessageRouter router;
protected MessageSender sender;
protected String        partName;

//---------- Initialization --------------------------------------
/**
* This constructor reqiuires the dispatcher to forward messages to
* the router from the message sender. This allows this class to 
* later call the correct router method.
*
* @param router    the router wanted the sender's messages.
* @param sender    tne sender of the messages.
* @param partName  the name of the sender part.
*/
public MessageDispatcher(MessageRouter router, MessageSender sender, String partName) {
    this.router = router;
    this.sender = sender;
    this.partName = partName;
}
//---------- MessageReceiver Implementation ----------------------
/**
* Forwards the message to the router.
*
* @param message  the message to forward.
*/
public void receive(Message message) {
    router.sendMessage(message, sender, partName);
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("MessageDispatcher" + text);
}

} // End class