package org.jcon.core.tron.std;

import org.jcon.core.tron.Message;

/**
* This interface represents a Message that travels between parts.
* A Message is a special type of Datatron. It has a name (or ID) and
* a PropMap. The name is for symantic understanding and routing.
* The name is always required. Null values are allowed. 
*
* @author Jack Harich 
*/
public class MessageStd extends PropMapStd implements Message {

//---------- Internal Fields -------------------------------------
protected String name;

//---------- Initialization --------------------------------------
public MessageStd() {
    // Manipulate superclass
    isNullValueAllowed = true;
    initConfiguration();
}
//---------- Superclass Overrides --------------------------------
/**
* Returns a String representation of the name and key values.
*/
public String toString() {
    String newLine = (super.isTree() ? "\n" : "");
    return "[Name=" + name + "] " + newLine + super.toString();
}
/**
* Returns a shallow copy of the object.
*/
public Object clone() {
    return super.clone();
}
//---------- Message Implementation ------------------------------
/**
* Sets the Message name. Period separators are encouraged for large
* systems. Spaces are not allowed.
* <p>
* Note the name must not only semantically describe the Message, but
* must be unique among all the other Messages in the portion of a
* system the Message will be used in.
* @param name  the name of the Message.
*/
public void setName(String name) {
    this.name = name.intern();
}    
/**
* Returns the name. This is used by MessageReceivers for determining
* what to do, in a manner similar to method names. For speed and code
* conciseness <b> you can assume the name has been interned. </b>
* @return  the interned name.
*/
public String getName() {
    return name;
}
/**
* A convenience method for Message reuse. It does a <code> setName()
* </code> and a <code> removeAll() </code> in a slightly faster manner
* than two separate method calls. In future versions it may do more.
* @param name  the name of the Message.
*/
public void reuse(String name) {
    this.name = name;
    // DUPE CODE with super.removeAll()
    properties.clear();
    if (isOrderedKeys) keys.removeAllElements();       
    
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("MessageStd" + text);
}


} // End class