package org.jcon.core.tron;

/**
* This interface represents a Message that travels between parts.
* A Message is a special type of Datatron. It has a name (or ID) and
* a PropMap. The name is for symantic understanding and routing.
* The name is always required. Null values are allowed. 
* <p>
* The implementation should have a no-arg constructor and a constructor
* that sets the name. 
*
* @author Jack Harich 
*/
public interface Message extends PropMap {

/**
* Sets the Message name. Period separators are encouraged for large
* systems. Spaces are not allowed.
* <p>
* Note the name must not only semantically describe the Message, but
* must be unique among all the other Messages in the portion of a
* system the Message will be used in.
* @param name  the name of the Message.
*/
public void setName(String name);
    
/**
* Returns the name. This is used by MessageReceivers for determining
* what to do, in a manner similar to method names. For speed and code
* conciseness <b> you can assume the name has been interned. </b>
* @return  the interned name.
*/
public String getName();

/**
* A convenience method for Message reuse. It does a <code> setName()
* </code> and a <code> removeAll() </code> in a slightly faster manner
* than two separate method calls. In future versions it may do more.
* @param name  the name of the Message.
*/
public void reuse(String name);


} // End interface 