package org.jcon.core.test;

import org.jcon.core.tron.PropMap;
import org.jcon.core.tron.std.PropMapStd;

/**
* This class is the unit test for PropMap.
*
* @author Jack Harich
*/ // java -nojit org.jcon.core.test.PropMap_UnitTest
public class PropMap_UnitTest {

//---------- Internal Fields -------------------------------------

//---------- Initialization --------------------------------------
public static void main(String args[]) {
    new PropMap_UnitTest().runTest();
}
//---------- Public Methods --------------------------------------
/**
* Returns null if test okay or a String describing failure.
* (Can become UnitTest interface method)
*/
public String runTest() {
    PropMap map = new PropMapStd();
    
    // Unconfigured test
    map.put("Key1", "Martha");
    //map.put("Key2", null); // Provoked exception
    map.put("Key3", "Helen");
    print(" - Unconfigured map is: " + map);
    
    // Configured test
    // (isNullValueAllowed, isOrderedKeys, keySeparator)
    map = new PropMapStd(true, true, "/");
    
    map.put("Key1", "Martha");
    map.put("Key2",  null);
    map.put("Key3Container/Georgia/Dekalb", "Clarkston");
    map.put("Key3Container/Georgia/Fulton", "Atlanta");
    map.put("Key4", "Helen");
    map.insertBefore("Key2", "Key1.5", "Betsy");
    
    print(" - Configured map is: \n\n" + map + "\n");
    print(" - Size = " + map.getSize());
    print(" - Deep key Atlanta = " + map.get("Key3Container/Georgia/Fulton"));
    
    // Done
    return null;
}
//---------- Protected Methods -----------------------------------

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("TestPropMap" + text);
}

} // End class