package org.jcon.core.test;


import org.jcon.core.part.Cell;
import org.jcon.core.part.CellNodeReplicator;
import org.jcon.core.part.Node;
import org.jcon.core.part.PartReader;
import org.jcon.core.part.std.NodeStd;
import org.jcon.core.part.std.MinimalCore;

/**
* This tests the Minimal Core by creating a simple
* System Tree, listing it, and various minor checks.
* It's also an example of how to create a system.
*
* @author Jack Harich
*/  // java -nojit org.jcon.core.test.MinimalCore_Test1
public class MinimalCore_Test1 {

//---------- Initialization --------------------------------------
public static void main(String args[]) {
    new MinimalCore_Test1().runTest();
}
//---------- Public Methods --------------------------------------
public void runTest() {
    System.out.println("");
    
    //----- Create rootNode, get rootCell
    Node rootNode = new MinimalCore().createRootNode();
    Cell rootCell = (Cell)rootNode.getPart();
    
    //----- Add test parts
    Node node;
    
    // Add TestPart1
    node = new NodeStd();
    node.setName("TestPart1");
    node.setVirtual(true);
    rootCell.appendNode(node);
    
    // Add TestCell, retain subCell
    CellNodeReplicator cellNodeReplicator = (CellNodeReplicator)
        rootCell.getPart("CellNodeReplicator");
    node = cellNodeReplicator.createCellNode(rootNode);
    node.setName("TestCell");
    rootCell.appendNode(node);
    Cell testCell = (Cell)node.getPart();
    
    // Add TestPart2 to subCell
    node = new NodeStd();
    node.setName("TestPart2");
    node.setVirtual(true);
    testCell.appendNode(node);
    
    // Test findPart() from subcell
    PartReader testCellReader = (PartReader)testCell.findPart("PartReader");
    print(" - The TestCell Tree is:\n" + testCellReader.listTree(false));
    
    // Find inherited part. Exception will occur if not there
    Object part = testCellReader.findPart("CellNodeReplicator");
    // Worked print(" - Found inherited part CellNodeReplicator - " + part);
    
    //----- List full tree
    PartReader rootReader = (PartReader)rootCell.getPart("PartReader");
    print(" - The System Tree is:\n" + rootReader.listTree(true));
}
//---------- Private Methods -------------------------------------
//--- Std
private static void print(String text) {
    System.out.println("MinimalCore_Test1" + text);
}

} // End class