package org.jcon.core.proto.c2.test;


import org.jcon.core.proto.c2.Cell;
import org.jcon.core.proto.c2.CellNodeReplicator;
import org.jcon.core.proto.c2.Node;
import org.jcon.core.proto.c2.PartReader;
import org.jcon.core.proto.c2.std.NodeStd;
import org.jcon.core.proto.c2.std.MinimalCore;

/**
* This tests the Minimal Core by creating a simple
* System Tree, listing it, and various minor checks.
* It's also an example of how to create a system.
* <p>
* Test results: <p> <pre>
* - The first test worked first try!
* - 2nd, add TestPart1 test worked first try!
* - 3rd, add TestCell, had bugs in CellNodeReplicatorStd:
*   - Forgot to skip not inheritable parts
*   - Forgot to make PartReader Replicable
*   and the subCell didn't appear in the tree listing
*   - Forgot to add to rootCell
* - 4th, add TestPart2, worked first try
* - 5th, test findPart on subcell, worked first try
* - 6th, test find inherited part, bug in CellStd
*   - Confused local variable name with class field
* - 7th, test find partName that doesn't exist, got proper exception
*
* @author Jack Harich
*/  // java -nojit org.jcon.core.proto.c2.test.MinimalCoreTest1
public class MinimalCoreTest1 {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new MinimalCoreTest1().runTest();
}
//---------- Public Methods ------------------------------
public void runTest() {
    System.out.println("");
    
    //----- Create rootNode, get rootCell
    Node rootNode = new MinimalCore().createRootNode();
    Cell rootCell = (Cell)rootNode.getPart();
    
    //----- Add test parts
    Node node;
    
    // Add TestPart1
    node = new NodeStd();
    node.setName("TestPart1");
    node.setVirtual(true);
    rootCell.appendNode(node);
    
    // Add TestCell, retain subCell
    CellNodeReplicator cellNodeReplicator = (CellNodeReplicator)
        rootCell.getPart("CellNodeReplicator");
    node = cellNodeReplicator.createCellNode(rootNode);
    node.setName("TestCell");
    rootCell.appendNode(node);
    Cell testCell = (Cell)node.getPart();
    
    // Add TestPart2 to subCell
    node = new NodeStd();
    node.setName("TestPart2");
    node.setVirtual(true);
    testCell.appendNode(node);
    
    // Test findPart() from subcell
    PartReader testCellReader = (PartReader)testCell.findPart("PartReader");
    print(" - The TestCell Tree is:\n" + testCellReader.listTree(false));
    
    // Find inherited part. Exception will occur if not there
    Object part = testCellReader.findPart("CellNodeReplicator");
    // Worked print(" - Found inherited part CellNodeReplicator - " + part);
    
    //----- List full tree
    PartReader rootReader = (PartReader)rootCell.getPart("PartReader");
    print(" - The System Tree is:\n" + rootReader.listTree(true));
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("MinimalCoreTest1" + text);
}

} // End class