package org.jcon.core.proto.c2.std;

import org.jcon.core.proto.c2.Node;
import org.jcon.core.proto.c2.NodeUser;

/**
* This class is the standard Node. See interface for doc.
*
* @author Jack Harich
*/
public class NodeStd implements Node {

//---------- Protected Fields ----------------------------
protected String name;
protected Object part;
protected Node   parentNode;

// The default on all of these is documented as false
protected boolean isCore;
protected boolean isContainer;
protected boolean isCompanion;
protected boolean isInheritable;
protected boolean isVirtual;
protected boolean isHidden;

//---------- Node Implementation -------------------------
//----- name
public void setName(String name) {
    // TODO - Validation
    this.name = name;
}
public String getName() {
    return name;
}
//----- part
public void setPart(Object part) {
    this.part = part;
    
    if (part instanceof NodeUser) {    
        ((NodeUser)part).setNode(this);
    }
}
public Object getPart() {
    return part;
}
//----- parentNode 
public void setParentNode(Node parentNode) {
    this.parentNode = parentNode;
}
public Node getParentNode() {
    return parentNode;
}
//----- isCore 
public void setCore(boolean isCore) {
    this.isCore = isCore;
}
public boolean isCore() {
    return isCore;
}
//----- isContainer 
public void setContainer(boolean isContainer) {
    this.isContainer = isContainer;
}
public boolean isContainer() {
    return isContainer;
}
//----- isCompanion 
public void setCompanion(boolean isCompanion) {
    this.isCompanion = isCompanion;
}
public boolean isCompanion() {
    return isCompanion;
}
//----- isInheritable
public void setInheritable(boolean isInheritable) {
    this.isInheritable = isInheritable;
}
public boolean isInheritable() {
    return isInheritable;
}
//----- isVirtual 
public void setVirtual(boolean isVirtual) {
    this.isVirtual = isVirtual;
}
public boolean isVirtual() {
    return isVirtual;
}
//----- isHidden
public void setHidden(boolean isHidden) {
    this.isHidden = isHidden;
}
public boolean isHidden() {
    return isHidden;
}
//----- Other
public Node getRootNode() {
    if (parentNode == null) {
        return this;
    } else {
        return parentNode.getRootNode();
    }
}
public String toString() {
    return name;
}


} // End class