package org.jcon.core.proto.c2;

/**
* A class may optionally implement this interface to 
* indicate it can replicate itself.
*
* @author Jack Harich
*/
public interface Replicable {

/**
* The instance should replicate itself. This is about half
* way between Java's "new" and "clone". The replication
* should include initialization state such as DK,
* but it should exclude current mission state, such as
* data read from a socket. This allows the replication to
* be used without the bother of initialization.
* <p>
* This is similar to life form reproduction. For example
* when a kitten is born, it has basic behavior and so is
* well initialized. But it lacks adult size and skills,
* and so lacks mission state.
*/
public Object replicate();


} // End interface


/**

import org.jcon.rapid.core1.Replicable;

//----------- Replicable Implementation ------------------
public Object replicate() {

}

*/