package org.jcon.core.proto.c2;

/**
* A class may optionally implement this interface to 
* indicate it wants to use other parts. This is an
* example of the Object User Pattern.
*
* @author Jack Harich
*/
public interface PartUser {

/**
* Returns an array of the part names this part needs to
* do its work.
*/
public String[] getPartNeeds();

/**
* Sets a named part, in response to part needs.
*/
public void setPart(String name, Object part);


} // End interface


/**

import org.jcon.rapid.core1.PartUser;

//----------- PartUser Implementation --------------------
public String[] getPartNeeds() {
    return new String[] {"PartName1", "PartName2"};
}
public void setPart(String name, Object part) {
    
}

*/