package org.jcon.core.proto.c2;

import java.util.Enumeration;

/**
* This interface represents a cell in a living organism,
* which in UHR is a container in a System Tree. A Cell
* holds zero or more Nodes, each of which may be a Cell
* or leaf.
* <p>
* Responsiblities are to manage the collection of nodes
* with the option of events. The nodes are maintained in
* the order added, allowing the designer to better
* organize the System Tree.
*
* @author Jack Harich
*/

public interface Cell extends NodeUser, Replicable {

/**
* Inserts the node before the provided index, which must
* exist. Throws an IllegalStateException if the index
* doesn't exist or the node has a duplicate name.
*/
public void insertNodeAt(Node node, int index);

/**
* Appends the node after the last index. Throws an
* IllegalStateException if the node has a duplicate name.
*/
public void appendNode(Node node);

/**
* Removes all nodes from the Cell.
*/
public void clear();

// Later - KeyedVector doesn't support this.
///**
//* Removes the node at the specified index in this cell.
//* Shifts any subsequent nodes to the left by subtracting
//* one from their indices. Returns the element that was 
//* removed from the list. Throws an IllegalStateException
//* if the index has no node.
//*/     
//public Node removeNodeAt(int index);

/**
* Removes the node. Returns the node removed or null if none.
*/     
public Node removeNode(Node node);


/**
* Returns the number of nodes in the cell. We use the
* Bean Spec method name style rather than size().
*/
public int getNodeCount();

/**
* Returns the node at the index or throws an 
* IllegalStateException if none.
*/
public Node getNodeAt(int index);

/**
* Returns an Enumeration of all nodes in the cell, in order.
*/
public Enumeration getNodes();

/**
* Returns the named node in this cell or null if not found.
*/
public Node getNode(String nodeName);

/**
* Returns the node this cell is in.
*/
public Node getCellNode();

/**
* Returns the named part in this cell or null if not found.
*/
public Object getPart(String partName);

/**
* Finds the named part. See PartReader for doc.
*/
public Object findPart(String partName);

} // End interface