package org.jcon.core.proto.c1.std;

import org.jcon.core.proto.c1.Cell;
import org.jcon.core.proto.c1.CellUser;
import org.jcon.core.proto.c1.CellLifecycle;
import org.jcon.core.proto.c1.WorkerWrapper;

/**
* This class is the standard CellLifecycle. For
* documentation see CellLifecycle for now. 
*
* @author Jack Harich
*/
public class CellLifecycleStd implements CellLifecycle {

//---------- Protected Fields ----------------------------
protected Cell    cell;
protected boolean isStarted;

//---------- ContainerLifecycle Implementation -----------
// TODO Will need CellDef later, which uses cell DK
// This is a very complex method

// NOTE - Currently not called in prototype.
// This class is not yet needed.
public void startCell() {
    
    print(".startCell() - Faking Cell DK");
    
    // Add a cell to myself for dramatic reproduction test
    Cell cell1 = (Cell)cell.replicate();
    cell1.setName("Container1");
    cell.addPart(cell1);
    
    // Add test non-core worker part
    WorkerWrapper wrapper = new WorkerWrapperStd();    
    wrapper.setName("Worker1");
    wrapper.setWorker(new Object());
    cell.addPart(wrapper);
}
public Object replicate() {
    // No initialization state is maintained
    return new CellLifecycleStd();
}
//----------- CellUser Implementation --------------------
public void setCell(Cell cell) {
    this.cell = cell;
}
public void releaseCell() {
    cell = null;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CellLifecycleStd" + text);
}

} // End class