package org.jcon.core.part;

/**
* A class may optionally implement this interface to 
* indicate it wants to use other parts. This is an
* example of the Object User Pattern.
*
* @author Jack Harich
*/
public interface PartUser {

/**
* Returns an array of the part names this part needs to
* do its work.
* @return  the names of the parts needed.
*/
public String[] getPartNamesNeeded();

/**
* Sets a named part, in response to part needs.
* @param name  the name of the needed part.
* @param part  the needed part.
*/
public void setPart(String name, Object part);


} // End interface


/**

import org.jcon.core.part;

//----------- PartUser Implementation ----------------------------
*
* Returns an array of the part names this part needs to
* do its work.
* @return  the names of the parts needed.
*
public String[] getPartNeeds() {
    return new String[] {"PartName1", "PartName2"};
}
*
* Sets a named part, in response to part needs.
* @param name  the name of the needed part.
* @param part  the needed part.
*
public void setPart(String name, Object part) {
    
}

*/